package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  BoundedLengthString,
  ModelArn,
  Timestamp,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InferenceExecutionSummary(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    scheduledStartTime: Optional[Timestamp] = Optional.Absent,
    dataStartTime: Optional[Timestamp] = Optional.Absent,
    dataEndTime: Optional[Timestamp] = Optional.Absent,
    dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
    ] = Optional.Absent,
    dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
    ] = Optional.Absent,
    customerResultObject: Optional[zio.aws.lookoutequipment.model.S3Object] =
      Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      Optional.Absent,
    failedReason: Optional[BoundedLengthString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary = {
    import InferenceExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(
        scheduledStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledStartTime)
      .optionallyWith(
        dataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTime)
      .optionallyWith(
        dataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTime)
      .optionallyWith(
        dataInputConfiguration.map(value => value.buildAwsValue())
      )(_.dataInputConfiguration)
      .optionallyWith(
        dataOutputConfiguration.map(value => value.buildAwsValue())
      )(_.dataOutputConfiguration)
      .optionallyWith(customerResultObject.map(value => value.buildAwsValue()))(
        _.customerResultObject
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceExecutionSummary
      .wrap(buildAwsValue())
}
object InferenceExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceExecutionSummary =
      zio.aws.lookoutequipment.model.InferenceExecutionSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        scheduledStartTime.map(value => value),
        dataStartTime.map(value => value),
        dataEndTime.map(value => value),
        dataInputConfiguration.map(value => value.asEditable),
        dataOutputConfiguration.map(value => value.asEditable),
        customerResultObject.map(value => value.asEditable),
        status.map(value => value),
        failedReason.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def scheduledStartTime: Optional[Timestamp]
    def dataStartTime: Optional[Timestamp]
    def dataEndTime: Optional[Timestamp]
    def dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ]
    def dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ]
    def customerResultObject
        : Optional[zio.aws.lookoutequipment.model.S3Object.ReadOnly]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus]
    def failedReason: Optional[BoundedLengthString]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getScheduledStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledStartTime", scheduledStartTime)
    def getDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTime", dataStartTime)
    def getDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTime", dataEndTime)
    def getDataInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataInputConfiguration",
      dataInputConfiguration
    )
    def getDataOutputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataOutputConfiguration",
      dataOutputConfiguration
    )
    def getCustomerResultObject
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("customerResultObject", customerResultObject)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ) extends zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val scheduledStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputConfiguration.wrap(value)
      )
    override val dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataOutputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceOutputConfiguration.wrap(value)
      )
    override val customerResultObject
        : Optional[zio.aws.lookoutequipment.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerResultObject())
        .map(value => zio.aws.lookoutequipment.model.S3Object.wrap(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceExecutionStatus.wrap(value)
        )
    override val failedReason: Optional[BoundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedReason())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ): zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly =
    new Wrapper(impl)
}
