package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait InferenceExecutionStatus {
  def unwrap: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus
}
object InferenceExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus
  ): zio.aws.lookoutequipment.model.InferenceExecutionStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.InferenceExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.lookoutequipment.model.InferenceExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.IN_PROGRESS
  }
  case object SUCCESS
      extends zio.aws.lookoutequipment.model.InferenceExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.SUCCESS
  }
  case object FAILED
      extends zio.aws.lookoutequipment.model.InferenceExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus =
      software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus.FAILED
  }
}
