package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  InferenceSchedulerName,
  ModelMetrics,
  InferenceSchedulerArn,
  EventDurationInSeconds
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InferenceEventSummary(
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    eventStartTime: Optional[Timestamp] = Optional.Absent,
    eventEndTime: Optional[Timestamp] = Optional.Absent,
    diagnostics: Optional[ModelMetrics] = Optional.Absent,
    eventDurationInSeconds: Optional[EventDurationInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceEventSummary = {
    import InferenceEventSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceEventSummary
      .builder()
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        eventStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventStartTime)
      .optionallyWith(
        eventEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.eventEndTime)
      .optionallyWith(
        diagnostics.map(value => ModelMetrics.unwrap(value): java.lang.String)
      )(_.diagnostics)
      .optionallyWith(
        eventDurationInSeconds.map(value =>
          EventDurationInSeconds.unwrap(value): java.lang.Long
        )
      )(_.eventDurationInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceEventSummary.wrap(buildAwsValue())
}
object InferenceEventSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceEventSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceEventSummary =
      zio.aws.lookoutequipment.model.InferenceEventSummary(
        inferenceSchedulerArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        eventStartTime.map(value => value),
        eventEndTime.map(value => value),
        diagnostics.map(value => value),
        eventDurationInSeconds.map(value => value)
      )
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def eventStartTime: Optional[Timestamp]
    def eventEndTime: Optional[Timestamp]
    def diagnostics: Optional[ModelMetrics]
    def eventDurationInSeconds: Optional[EventDurationInSeconds]
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getEventStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventStartTime", eventStartTime)
    def getEventEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventEndTime", eventEndTime)
    def getDiagnostics: ZIO[Any, AwsError, ModelMetrics] =
      AwsError.unwrapOptionField("diagnostics", diagnostics)
    def getEventDurationInSeconds: ZIO[Any, AwsError, EventDurationInSeconds] =
      AwsError.unwrapOptionField(
        "eventDurationInSeconds",
        eventDurationInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceEventSummary
  ) extends zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly {
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val eventStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val eventEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val diagnostics: Optional[ModelMetrics] = zio.aws.core.internal
      .optionalFromNullable(impl.diagnostics())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelMetrics(value)
      )
    override val eventDurationInSeconds: Optional[EventDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDurationInSeconds())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .EventDurationInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceEventSummary
  ): zio.aws.lookoutequipment.model.InferenceEventSummary.ReadOnly =
    new Wrapper(impl)
}
