package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  BoundedLengthString,
  DatasetArn,
  OffCondition,
  ModelArn,
  Timestamp,
  ModelMetrics,
  DatasetName,
  ModelName,
  KmsKeyArn,
  InlineDataSchema
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeModelResponse(
    modelName: Optional[ModelName] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    datasetName: Optional[DatasetName] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    schema: Optional[InlineDataSchema] = Optional.Absent,
    labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = Optional.Absent,
    trainingDataStartTime: Optional[Timestamp] = Optional.Absent,
    trainingDataEndTime: Optional[Timestamp] = Optional.Absent,
    evaluationDataStartTime: Optional[Timestamp] = Optional.Absent,
    evaluationDataEndTime: Optional[Timestamp] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
    ] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      Optional.Absent,
    trainingExecutionStartTime: Optional[Timestamp] = Optional.Absent,
    trainingExecutionEndTime: Optional[Timestamp] = Optional.Absent,
    failedReason: Optional[BoundedLengthString] = Optional.Absent,
    modelMetrics: Optional[ModelMetrics] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    serverSideKmsKeyId: Optional[KmsKeyArn] = Optional.Absent,
    offCondition: Optional[OffCondition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse = {
    import DescribeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        schema.map(value => InlineDataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .optionallyWith(
        trainingDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataStartTime)
      .optionallyWith(
        trainingDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataEndTime)
      .optionallyWith(
        evaluationDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataStartTime)
      .optionallyWith(
        evaluationDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataEndTime)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        dataPreProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.dataPreProcessingConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        trainingExecutionStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.trainingExecutionStartTime)
      .optionallyWith(
        trainingExecutionEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingExecutionEndTime)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .optionallyWith(
        modelMetrics.map(value => ModelMetrics.unwrap(value): java.lang.String)
      )(_.modelMetrics)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        offCondition.map(value => OffCondition.unwrap(value): java.lang.String)
      )(_.offCondition)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeModelResponse.wrap(buildAwsValue())
}
object DescribeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeModelResponse =
      zio.aws.lookoutequipment.model.DescribeModelResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        schema.map(value => value),
        labelsInputConfiguration.map(value => value.asEditable),
        trainingDataStartTime.map(value => value),
        trainingDataEndTime.map(value => value),
        evaluationDataStartTime.map(value => value),
        evaluationDataEndTime.map(value => value),
        roleArn.map(value => value),
        dataPreProcessingConfiguration.map(value => value.asEditable),
        status.map(value => value),
        trainingExecutionStartTime.map(value => value),
        trainingExecutionEndTime.map(value => value),
        failedReason.map(value => value),
        modelMetrics.map(value => value),
        lastUpdatedTime.map(value => value),
        createdAt.map(value => value),
        serverSideKmsKeyId.map(value => value),
        offCondition.map(value => value)
      )
    def modelName: Optional[ModelName]
    def modelArn: Optional[ModelArn]
    def datasetName: Optional[DatasetName]
    def datasetArn: Optional[DatasetArn]
    def schema: Optional[InlineDataSchema]
    def labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def trainingDataStartTime: Optional[Timestamp]
    def trainingDataEndTime: Optional[Timestamp]
    def evaluationDataStartTime: Optional[Timestamp]
    def evaluationDataEndTime: Optional[Timestamp]
    def roleArn: Optional[IamRoleArn]
    def dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ]
    def status: Optional[zio.aws.lookoutequipment.model.ModelStatus]
    def trainingExecutionStartTime: Optional[Timestamp]
    def trainingExecutionEndTime: Optional[Timestamp]
    def failedReason: Optional[BoundedLengthString]
    def modelMetrics: Optional[ModelMetrics]
    def lastUpdatedTime: Optional[Timestamp]
    def createdAt: Optional[Timestamp]
    def serverSideKmsKeyId: Optional[KmsKeyArn]
    def offCondition: Optional[OffCondition]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getTrainingDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataStartTime", trainingDataStartTime)
    def getTrainingDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataEndTime", trainingDataEndTime)
    def getEvaluationDataStartTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("evaluationDataStartTime", evaluationDataStartTime)
    def getEvaluationDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("evaluationDataEndTime", evaluationDataEndTime)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPreProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataPreProcessingConfiguration",
      dataPreProcessingConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTrainingExecutionStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "trainingExecutionStartTime",
        trainingExecutionStartTime
      )
    def getTrainingExecutionEndTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("trainingExecutionEndTime", trainingExecutionEndTime)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
    def getModelMetrics: ZIO[Any, AwsError, ModelMetrics] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getOffCondition: ZIO[Any, AwsError, OffCondition] =
      AwsError.unwrapOptionField("offCondition", offCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ) extends zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val schema: Optional[InlineDataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
      )
    override val labelsInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val trainingDataStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val trainingDataEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingDataEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val evaluationDataStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationDataStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val evaluationDataEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationDataEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val dataPreProcessingConfiguration: Optional[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPreProcessingConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
          .wrap(value)
      )
    override val status: Optional[zio.aws.lookoutequipment.model.ModelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val trainingExecutionStartTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingExecutionStartTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val trainingExecutionEndTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingExecutionEndTime())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.Timestamp(value)
        )
    override val failedReason: Optional[BoundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedReason())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
        )
    override val modelMetrics: Optional[ModelMetrics] = zio.aws.core.internal
      .optionalFromNullable(impl.modelMetrics())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelMetrics(value)
      )
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val serverSideKmsKeyId: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val offCondition: Optional[OffCondition] = zio.aws.core.internal
      .optionalFromNullable(impl.offCondition())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.OffCondition(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ): zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    new Wrapper(impl)
}
