package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{LabelId, LabelGroupName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLabelRequest(
    labelGroupName: LabelGroupName,
    labelId: LabelId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest = {
    import DescribeLabelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .labelId(LabelId.unwrap(labelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DescribeLabelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeLabelRequest.wrap(buildAwsValue())
}
object DescribeLabelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeLabelRequest =
      zio.aws.lookoutequipment.model
        .DescribeLabelRequest(labelGroupName, labelId)
    def labelGroupName: LabelGroupName
    def labelId: LabelId
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getLabelId: ZIO[Any, Nothing, LabelId] = ZIO.succeed(labelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest
  ) extends zio.aws.lookoutequipment.model.DescribeLabelRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val labelId: LabelId =
      zio.aws.lookoutequipment.model.primitives.LabelId(impl.labelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest
  ): zio.aws.lookoutequipment.model.DescribeLabelRequest.ReadOnly = new Wrapper(
    impl
  )
}
