package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  FaultCode,
  LabelGroupArn,
  LabelGroupName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeLabelGroupResponse(
    labelGroupName: Optional[LabelGroupName] = Optional.Absent,
    labelGroupArn: Optional[LabelGroupArn] = Optional.Absent,
    faultCodes: Optional[Iterable[FaultCode]] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse = {
    import DescribeLabelGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse
      .builder()
      .optionallyWith(
        labelGroupName.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupName)
      .optionallyWith(
        labelGroupArn.map(value =>
          LabelGroupArn.unwrap(value): java.lang.String
        )
      )(_.labelGroupArn)
      .optionallyWith(
        faultCodes.map(value =>
          value.map { item =>
            FaultCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.faultCodes)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeLabelGroupResponse
      .wrap(buildAwsValue())
}
object DescribeLabelGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeLabelGroupResponse =
      zio.aws.lookoutequipment.model.DescribeLabelGroupResponse(
        labelGroupName.map(value => value),
        labelGroupArn.map(value => value),
        faultCodes.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def labelGroupName: Optional[LabelGroupName]
    def labelGroupArn: Optional[LabelGroupArn]
    def faultCodes: Optional[List[FaultCode]]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def getLabelGroupName: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField("labelGroupName", labelGroupName)
    def getLabelGroupArn: ZIO[Any, AwsError, LabelGroupArn] =
      AwsError.unwrapOptionField("labelGroupArn", labelGroupArn)
    def getFaultCodes: ZIO[Any, AwsError, List[FaultCode]] =
      AwsError.unwrapOptionField("faultCodes", faultCodes)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse
  ) extends zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly {
    override val labelGroupName: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
    override val labelGroupArn: Optional[LabelGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.labelGroupArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.LabelGroupArn(value)
      )
    override val faultCodes: Optional[List[FaultCode]] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.primitives.FaultCode(item)
        }.toList
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse
  ): zio.aws.lookoutequipment.model.DescribeLabelGroupResponse.ReadOnly =
    new Wrapper(impl)
}
