package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  DataDelayOffsetInMinutes,
  ModelArn,
  Timestamp,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName,
  KmsKeyArn
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeInferenceSchedulerResponse(
    modelArn: Optional[ModelArn] = Optional.Absent,
    modelName: Optional[ModelName] = Optional.Absent,
    inferenceSchedulerName: Optional[InferenceSchedulerName] = Optional.Absent,
    inferenceSchedulerArn: Optional[InferenceSchedulerArn] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      Optional.Absent,
    dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      Optional.Absent,
    dataUploadFrequency: Optional[
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
    ] = Optional.Absent,
    dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    serverSideKmsKeyId: Optional[KmsKeyArn] = Optional.Absent,
    latestInferenceResult: Optional[
      zio.aws.lookoutequipment.model.LatestInferenceResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse = {
    import DescribeInferenceSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .optionallyWith(dataUploadFrequency.map(value => value.unwrap))(
        _.dataUploadFrequency
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        dataInputConfiguration.map(value => value.buildAwsValue())
      )(_.dataInputConfiguration)
      .optionallyWith(
        dataOutputConfiguration.map(value => value.buildAwsValue())
      )(_.dataOutputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(latestInferenceResult.map(value => value.unwrap))(
        _.latestInferenceResult
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse
      .wrap(buildAwsValue())
}
object DescribeInferenceSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse =
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse(
        modelArn.map(value => value),
        modelName.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value),
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        dataInputConfiguration.map(value => value.asEditable),
        dataOutputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value),
        serverSideKmsKeyId.map(value => value),
        latestInferenceResult.map(value => value)
      )
    def modelArn: Optional[ModelArn]
    def modelName: Optional[ModelName]
    def inferenceSchedulerName: Optional[InferenceSchedulerName]
    def inferenceSchedulerArn: Optional[InferenceSchedulerArn]
    def status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes]
    def dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ]
    def dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ]
    def roleArn: Optional[IamRoleArn]
    def serverSideKmsKeyId: Optional[KmsKeyArn]
    def latestInferenceResult
        : Optional[zio.aws.lookoutequipment.model.LatestInferenceResult]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = AwsError.unwrapOptionField("dataUploadFrequency", dataUploadFrequency)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDataInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataInputConfiguration",
      dataInputConfiguration
    )
    def getDataOutputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataOutputConfiguration",
      dataOutputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getLatestInferenceResult: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LatestInferenceResult
    ] =
      AwsError.unwrapOptionField("latestInferenceResult", latestInferenceResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly {
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val inferenceSchedulerName: Optional[InferenceSchedulerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .InferenceSchedulerName(value)
        )
    override val inferenceSchedulerArn: Optional[InferenceSchedulerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSchedulerArn())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
        )
    override val status
        : Optional[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
    override val dataDelayOffsetInMinutes: Optional[DataDelayOffsetInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : Optional[zio.aws.lookoutequipment.model.DataUploadFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataUploadFrequency())
        .map(value =>
          zio.aws.lookoutequipment.model.DataUploadFrequency.wrap(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputConfiguration.wrap(value)
      )
    override val dataOutputConfiguration: Optional[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataOutputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceOutputConfiguration.wrap(value)
      )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val serverSideKmsKeyId: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val latestInferenceResult
        : Optional[zio.aws.lookoutequipment.model.LatestInferenceResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestInferenceResult())
        .map(value =>
          zio.aws.lookoutequipment.model.LatestInferenceResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ): zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
