package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  BoundedLengthString,
  DatasetArn,
  Timestamp,
  DataSizeInBytes,
  IngestionJobId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDataIngestionJobResponse(
    jobId: Optional[IngestionJobId] = Optional.Absent,
    datasetArn: Optional[DatasetArn] = Optional.Absent,
    ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
    ] = Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.lookoutequipment.model.IngestionJobStatus] =
      Optional.Absent,
    failedReason: Optional[BoundedLengthString] = Optional.Absent,
    dataQualitySummary: Optional[
      zio.aws.lookoutequipment.model.DataQualitySummary
    ] = Optional.Absent,
    ingestedFilesSummary: Optional[
      zio.aws.lookoutequipment.model.IngestedFilesSummary
    ] = Optional.Absent,
    statusDetail: Optional[BoundedLengthString] = Optional.Absent,
    ingestedDataSize: Optional[DataSizeInBytes] = Optional.Absent,
    dataStartTime: Optional[Timestamp] = Optional.Absent,
    dataEndTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse = {
    import DescribeDataIngestionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => IngestionJobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        ingestionInputConfiguration.map(value => value.buildAwsValue())
      )(_.ingestionInputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .optionallyWith(dataQualitySummary.map(value => value.buildAwsValue()))(
        _.dataQualitySummary
      )
      .optionallyWith(ingestedFilesSummary.map(value => value.buildAwsValue()))(
        _.ingestedFilesSummary
      )
      .optionallyWith(
        statusDetail.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.statusDetail)
      .optionallyWith(
        ingestedDataSize.map(value =>
          DataSizeInBytes.unwrap(value): java.lang.Long
        )
      )(_.ingestedDataSize)
      .optionallyWith(
        dataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTime)
      .optionallyWith(
        dataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTime)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse
      .wrap(buildAwsValue())
}
object DescribeDataIngestionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse =
      zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse(
        jobId.map(value => value),
        datasetArn.map(value => value),
        ingestionInputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        failedReason.map(value => value),
        dataQualitySummary.map(value => value.asEditable),
        ingestedFilesSummary.map(value => value.asEditable),
        statusDetail.map(value => value),
        ingestedDataSize.map(value => value),
        dataStartTime.map(value => value),
        dataEndTime.map(value => value)
      )
    def jobId: Optional[IngestionJobId]
    def datasetArn: Optional[DatasetArn]
    def ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ]
    def roleArn: Optional[IamRoleArn]
    def createdAt: Optional[Timestamp]
    def status: Optional[zio.aws.lookoutequipment.model.IngestionJobStatus]
    def failedReason: Optional[BoundedLengthString]
    def dataQualitySummary
        : Optional[zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly]
    def ingestedFilesSummary
        : Optional[zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly]
    def statusDetail: Optional[BoundedLengthString]
    def ingestedDataSize: Optional[DataSizeInBytes]
    def dataStartTime: Optional[Timestamp]
    def dataEndTime: Optional[Timestamp]
    def getJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getIngestionInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingestionInputConfiguration",
      ingestionInputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionJobStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
    def getDataQualitySummary: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly
    ] = AwsError.unwrapOptionField("dataQualitySummary", dataQualitySummary)
    def getIngestedFilesSummary: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly
    ] = AwsError.unwrapOptionField("ingestedFilesSummary", ingestedFilesSummary)
    def getStatusDetail: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
    def getIngestedDataSize: ZIO[Any, AwsError, DataSizeInBytes] =
      AwsError.unwrapOptionField("ingestedDataSize", ingestedDataSize)
    def getDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTime", dataStartTime)
    def getDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTime", dataEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ) extends zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly {
    override val jobId: Optional[IngestionJobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
      )
    override val datasetArn: Optional[DatasetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val ingestionInputConfiguration: Optional[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ingestionInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionInputConfiguration.wrap(value)
      )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.lookoutequipment.model.IngestionJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.IngestionJobStatus.wrap(value)
        )
    override val failedReason: Optional[BoundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedReason())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
        )
    override val dataQualitySummary
        : Optional[zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataQualitySummary())
        .map(value =>
          zio.aws.lookoutequipment.model.DataQualitySummary.wrap(value)
        )
    override val ingestedFilesSummary: Optional[
      zio.aws.lookoutequipment.model.IngestedFilesSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ingestedFilesSummary())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestedFilesSummary.wrap(value)
      )
    override val statusDetail: Optional[BoundedLengthString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetail())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
        )
    override val ingestedDataSize: Optional[DataSizeInBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestedDataSize())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.DataSizeInBytes(value)
        )
    override val dataStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ): zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly =
    new Wrapper(impl)
}
