package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.LabelGroupName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLabelGroupRequest(labelGroupName: LabelGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest = {
    import DeleteLabelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DeleteLabelGroupRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteLabelGroupRequest.wrap(buildAwsValue())
}
object DeleteLabelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DeleteLabelGroupRequest =
      zio.aws.lookoutequipment.model.DeleteLabelGroupRequest(labelGroupName)
    def labelGroupName: LabelGroupName
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest
  ) extends zio.aws.lookoutequipment.model.DeleteLabelGroupRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest
  ): zio.aws.lookoutequipment.model.DeleteLabelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
