package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.InferenceSchedulerIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInferenceSchedulerRequest(
    inferenceSchedulerName: InferenceSchedulerIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest = {
    import DeleteInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest
      .builder()
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DeleteInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object DeleteInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DeleteInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model
        .DeleteInferenceSchedulerRequest(inferenceSchedulerName)
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.DeleteInferenceSchedulerRequest.ReadOnly {
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.DeleteInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
