package zio.aws.lookoutequipment.model
import scala.jdk.CollectionConverters._
sealed trait DatasetStatus {
  def unwrap
      : software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus
  ): zio.aws.lookoutequipment.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.INGESTION_IN_PROGRESS =>
      val r = INGESTION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lookoutequipment.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.lookoutequipment.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.CREATED
  }
  case object INGESTION_IN_PROGRESS
      extends zio.aws.lookoutequipment.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.INGESTION_IN_PROGRESS
  }
  case object ACTIVE extends zio.aws.lookoutequipment.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus =
      software.amazon.awssdk.services.lookoutequipment.model.DatasetStatus.ACTIVE
  }
}
