package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.InlineDataSchema
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatasetSchema(
    inlineDataSchema: Optional[InlineDataSchema] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema = {
    import DatasetSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema
      .builder()
      .optionallyWith(
        inlineDataSchema.map(value =>
          InlineDataSchema.unwrap(value): java.lang.String
        )
      )(_.inlineDataSchema)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly =
    zio.aws.lookoutequipment.model.DatasetSchema.wrap(buildAwsValue())
}
object DatasetSchema {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DatasetSchema =
      zio.aws.lookoutequipment.model
        .DatasetSchema(inlineDataSchema.map(value => value))
    def inlineDataSchema: Optional[InlineDataSchema]
    def getInlineDataSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("inlineDataSchema", inlineDataSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema
  ) extends zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly {
    override val inlineDataSchema: Optional[InlineDataSchema] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inlineDataSchema())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DatasetSchema
  ): zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly = new Wrapper(impl)
}
