package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DataQualitySummary(
    insufficientSensorData: zio.aws.lookoutequipment.model.InsufficientSensorData,
    missingSensorData: zio.aws.lookoutequipment.model.MissingSensorData,
    invalidSensorData: zio.aws.lookoutequipment.model.InvalidSensorData,
    unsupportedTimestamps: zio.aws.lookoutequipment.model.UnsupportedTimestamps,
    duplicateTimestamps: zio.aws.lookoutequipment.model.DuplicateTimestamps
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary = {
    import DataQualitySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary
      .builder()
      .insufficientSensorData(insufficientSensorData.buildAwsValue())
      .missingSensorData(missingSensorData.buildAwsValue())
      .invalidSensorData(invalidSensorData.buildAwsValue())
      .unsupportedTimestamps(unsupportedTimestamps.buildAwsValue())
      .duplicateTimestamps(duplicateTimestamps.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly =
    zio.aws.lookoutequipment.model.DataQualitySummary.wrap(buildAwsValue())
}
object DataQualitySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DataQualitySummary =
      zio.aws.lookoutequipment.model.DataQualitySummary(
        insufficientSensorData.asEditable,
        missingSensorData.asEditable,
        invalidSensorData.asEditable,
        unsupportedTimestamps.asEditable,
        duplicateTimestamps.asEditable
      )
    def insufficientSensorData
        : zio.aws.lookoutequipment.model.InsufficientSensorData.ReadOnly
    def missingSensorData
        : zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly
    def invalidSensorData
        : zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly
    def unsupportedTimestamps
        : zio.aws.lookoutequipment.model.UnsupportedTimestamps.ReadOnly
    def duplicateTimestamps
        : zio.aws.lookoutequipment.model.DuplicateTimestamps.ReadOnly
    def getInsufficientSensorData: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.InsufficientSensorData.ReadOnly
    ] = ZIO.succeed(insufficientSensorData)
    def getMissingSensorData: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly
    ] = ZIO.succeed(missingSensorData)
    def getInvalidSensorData: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly
    ] = ZIO.succeed(invalidSensorData)
    def getUnsupportedTimestamps: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.UnsupportedTimestamps.ReadOnly
    ] = ZIO.succeed(unsupportedTimestamps)
    def getDuplicateTimestamps: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.DuplicateTimestamps.ReadOnly
    ] = ZIO.succeed(duplicateTimestamps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary
  ) extends zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly {
    override val insufficientSensorData
        : zio.aws.lookoutequipment.model.InsufficientSensorData.ReadOnly =
      zio.aws.lookoutequipment.model.InsufficientSensorData
        .wrap(impl.insufficientSensorData())
    override val missingSensorData
        : zio.aws.lookoutequipment.model.MissingSensorData.ReadOnly =
      zio.aws.lookoutequipment.model.MissingSensorData
        .wrap(impl.missingSensorData())
    override val invalidSensorData
        : zio.aws.lookoutequipment.model.InvalidSensorData.ReadOnly =
      zio.aws.lookoutequipment.model.InvalidSensorData
        .wrap(impl.invalidSensorData())
    override val unsupportedTimestamps
        : zio.aws.lookoutequipment.model.UnsupportedTimestamps.ReadOnly =
      zio.aws.lookoutequipment.model.UnsupportedTimestamps
        .wrap(impl.unsupportedTimestamps())
    override val duplicateTimestamps
        : zio.aws.lookoutequipment.model.DuplicateTimestamps.ReadOnly =
      zio.aws.lookoutequipment.model.DuplicateTimestamps
        .wrap(impl.duplicateTimestamps())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataQualitySummary
  ): zio.aws.lookoutequipment.model.DataQualitySummary.ReadOnly = new Wrapper(
    impl
  )
}
