package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataPreProcessingConfiguration(
    targetSamplingRate: Optional[
      zio.aws.lookoutequipment.model.TargetSamplingRate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration = {
    import DataPreProcessingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration
      .builder()
      .optionallyWith(targetSamplingRate.map(value => value.unwrap))(
        _.targetSamplingRate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly =
    zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
      .wrap(buildAwsValue())
}
object DataPreProcessingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DataPreProcessingConfiguration =
      zio.aws.lookoutequipment.model
        .DataPreProcessingConfiguration(targetSamplingRate.map(value => value))
    def targetSamplingRate
        : Optional[zio.aws.lookoutequipment.model.TargetSamplingRate]
    def getTargetSamplingRate: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.TargetSamplingRate
    ] = AwsError.unwrapOptionField("targetSamplingRate", targetSamplingRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration
  ) extends zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly {
    override val targetSamplingRate
        : Optional[zio.aws.lookoutequipment.model.TargetSamplingRate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetSamplingRate())
        .map(value =>
          zio.aws.lookoutequipment.model.TargetSamplingRate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration
  ): zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly =
    new Wrapper(impl)
}
