package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.LabelId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLabelResponse(
    labelId: Optional[LabelId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse = {
    import CreateLabelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse
      .builder()
      .optionallyWith(
        labelId.map(value => LabelId.unwrap(value): java.lang.String)
      )(_.labelId)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly =
    zio.aws.lookoutequipment.model.CreateLabelResponse.wrap(buildAwsValue())
}
object CreateLabelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateLabelResponse =
      zio.aws.lookoutequipment.model
        .CreateLabelResponse(labelId.map(value => value))
    def labelId: Optional[LabelId]
    def getLabelId: ZIO[Any, AwsError, LabelId] =
      AwsError.unwrapOptionField("labelId", labelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse
  ) extends zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly {
    override val labelId: Optional[LabelId] = zio.aws.core.internal
      .optionalFromNullable(impl.labelId())
      .map(value => zio.aws.lookoutequipment.model.primitives.LabelId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse
  ): zio.aws.lookoutequipment.model.CreateLabelResponse.ReadOnly = new Wrapper(
    impl
  )
}
