package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{LabelGroupArn, LabelGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLabelGroupResponse(
    labelGroupName: Optional[LabelGroupName] = Optional.Absent,
    labelGroupArn: Optional[LabelGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse = {
    import CreateLabelGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse
      .builder()
      .optionallyWith(
        labelGroupName.map(value =>
          LabelGroupName.unwrap(value): java.lang.String
        )
      )(_.labelGroupName)
      .optionallyWith(
        labelGroupArn.map(value =>
          LabelGroupArn.unwrap(value): java.lang.String
        )
      )(_.labelGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly =
    zio.aws.lookoutequipment.model.CreateLabelGroupResponse
      .wrap(buildAwsValue())
}
object CreateLabelGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateLabelGroupResponse =
      zio.aws.lookoutequipment.model.CreateLabelGroupResponse(
        labelGroupName.map(value => value),
        labelGroupArn.map(value => value)
      )
    def labelGroupName: Optional[LabelGroupName]
    def labelGroupArn: Optional[LabelGroupArn]
    def getLabelGroupName: ZIO[Any, AwsError, LabelGroupName] =
      AwsError.unwrapOptionField("labelGroupName", labelGroupName)
    def getLabelGroupArn: ZIO[Any, AwsError, LabelGroupArn] =
      AwsError.unwrapOptionField("labelGroupArn", labelGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse
  ) extends zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly {
    override val labelGroupName: Optional[LabelGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelGroupName())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives.LabelGroupName(value)
        )
    override val labelGroupArn: Optional[LabelGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.labelGroupArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.LabelGroupArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse
  ): zio.aws.lookoutequipment.model.CreateLabelGroupResponse.ReadOnly =
    new Wrapper(impl)
}
