package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IdempotenceToken,
  FaultCode,
  LabelGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLabelGroupRequest(
    labelGroupName: LabelGroupName,
    faultCodes: Optional[Iterable[FaultCode]] = Optional.Absent,
    clientToken: IdempotenceToken,
    tags: Optional[Iterable[zio.aws.lookoutequipment.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest = {
    import CreateLabelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest
      .builder()
      .labelGroupName(LabelGroupName.unwrap(labelGroupName): java.lang.String)
      .optionallyWith(
        faultCodes.map(value =>
          value.map { item =>
            FaultCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.faultCodes)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateLabelGroupRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateLabelGroupRequest.wrap(buildAwsValue())
}
object CreateLabelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateLabelGroupRequest =
      zio.aws.lookoutequipment.model.CreateLabelGroupRequest(
        labelGroupName,
        faultCodes.map(value => value),
        clientToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def labelGroupName: LabelGroupName
    def faultCodes: Optional[List[FaultCode]]
    def clientToken: IdempotenceToken
    def tags: Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def getLabelGroupName: ZIO[Any, Nothing, LabelGroupName] =
      ZIO.succeed(labelGroupName)
    def getFaultCodes: ZIO[Any, AwsError, List[FaultCode]] =
      AwsError.unwrapOptionField("faultCodes", faultCodes)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest
  ) extends zio.aws.lookoutequipment.model.CreateLabelGroupRequest.ReadOnly {
    override val labelGroupName: LabelGroupName =
      zio.aws.lookoutequipment.model.primitives
        .LabelGroupName(impl.labelGroupName())
    override val faultCodes: Optional[List[FaultCode]] = zio.aws.core.internal
      .optionalFromNullable(impl.faultCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.primitives.FaultCode(item)
        }.toList
      )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val tags
        : Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest
  ): zio.aws.lookoutequipment.model.CreateLabelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
