package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IdempotenceToken,
  NameOrArn,
  DatasetName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDatasetRequest(
    datasetName: DatasetName,
    datasetSchema: Optional[zio.aws.lookoutequipment.model.DatasetSchema] =
      Optional.Absent,
    serverSideKmsKeyId: Optional[NameOrArn] = Optional.Absent,
    clientToken: IdempotenceToken,
    tags: Optional[Iterable[zio.aws.lookoutequipment.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(datasetSchema.map(value => value.buildAwsValue()))(
        _.datasetSchema
      )
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          NameOrArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CreateDatasetRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateDatasetRequest =
      zio.aws.lookoutequipment.model.CreateDatasetRequest(
        datasetName,
        datasetSchema.map(value => value.asEditable),
        serverSideKmsKeyId.map(value => value),
        clientToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetName: DatasetName
    def datasetSchema
        : Optional[zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly]
    def serverSideKmsKeyId: Optional[NameOrArn]
    def clientToken: IdempotenceToken
    def tags: Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getDatasetSchema: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly
    ] = AwsError.unwrapOptionField("datasetSchema", datasetSchema)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest
  ) extends zio.aws.lookoutequipment.model.CreateDatasetRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.lookoutequipment.model.primitives.DatasetName(impl.datasetName())
    override val datasetSchema
        : Optional[zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetSchema())
        .map(value => zio.aws.lookoutequipment.model.DatasetSchema.wrap(value))
    override val serverSideKmsKeyId: Optional[NameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val tags
        : Optional[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest
  ): zio.aws.lookoutequipment.model.CreateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
