package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CategoricalValues(
    status: zio.aws.lookoutequipment.model.StatisticalIssueStatus,
    numberOfCategory: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CategoricalValues = {
    import CategoricalValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CategoricalValues
      .builder()
      .status(status.unwrap)
      .optionallyWith(numberOfCategory.map(value => value: java.lang.Integer))(
        _.numberOfCategory
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly =
    zio.aws.lookoutequipment.model.CategoricalValues.wrap(buildAwsValue())
}
object CategoricalValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CategoricalValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CategoricalValues =
      zio.aws.lookoutequipment.model
        .CategoricalValues(status, numberOfCategory.map(value => value))
    def status: zio.aws.lookoutequipment.model.StatisticalIssueStatus
    def numberOfCategory: Optional[Integer]
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.lookoutequipment.model.StatisticalIssueStatus
    ] = ZIO.succeed(status)
    def getNumberOfCategory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfCategory", numberOfCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CategoricalValues
  ) extends zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly {
    override val status: zio.aws.lookoutequipment.model.StatisticalIssueStatus =
      zio.aws.lookoutequipment.model.StatisticalIssueStatus.wrap(impl.status())
    override val numberOfCategory: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfCategory())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CategoricalValues
  ): zio.aws.lookoutequipment.model.CategoricalValues.ReadOnly = new Wrapper(
    impl
  )
}
