package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DatasetArn,
  ModelArn,
  Timestamp,
  DatasetName,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModelSummary(
    modelName: Option[ModelName] = None,
    modelArn: Option[ModelArn] = None,
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    status: Option[zio.aws.lookoutequipment.model.ModelStatus] = None,
    createdAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ModelSummary = {
    import ModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ModelSummary.ReadOnly =
    zio.aws.lookoutequipment.model.ModelSummary.wrap(buildAwsValue())
}
object ModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ModelSummary =
      zio.aws.lookoutequipment.model.ModelSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value)
      )
    def modelName: Option[ModelName]
    def modelArn: Option[ModelArn]
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def status: Option[zio.aws.lookoutequipment.model.ModelStatus]
    def createdAt: Option[Timestamp]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ) extends zio.aws.lookoutequipment.model.ModelSummary.ReadOnly {
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val status: Option[zio.aws.lookoutequipment.model.ModelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ModelSummary
  ): zio.aws.lookoutequipment.model.ModelSummary.ReadOnly = new Wrapper(impl)
}
