package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListModelsResponse(
    nextToken: Option[NextToken] = None,
    modelSummaries: Option[
      Iterable[zio.aws.lookoutequipment.model.ModelSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse = {
    import ListModelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        modelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelSummaries)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListModelsResponse.wrap(buildAwsValue())
}
object ListModelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListModelsResponse =
      zio.aws.lookoutequipment.model.ListModelsResponse(
        nextToken.map(value => value),
        modelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def modelSummaries
        : Option[List[zio.aws.lookoutequipment.model.ModelSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModelSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("modelSummaries", modelSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ) extends zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val modelSummaries
        : Option[List[zio.aws.lookoutequipment.model.ModelSummary.ReadOnly]] =
      scala
        .Option(impl.modelSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lookoutequipment.model.ModelSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse
  ): zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
