package zio.aws.lookoutequipment.model
import java.lang.Integer
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DatasetName,
  ModelName,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListModelsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    status: Option[zio.aws.lookoutequipment.model.ModelStatus] = None,
    modelNameBeginsWith: Option[ModelName] = None,
    datasetNameBeginsWith: Option[DatasetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest = {
    import ListModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        modelNameBeginsWith.map(value =>
          ModelName.unwrap(value): java.lang.String
        )
      )(_.modelNameBeginsWith)
      .optionallyWith(
        datasetNameBeginsWith.map(value =>
          DatasetName.unwrap(value): java.lang.String
        )
      )(_.datasetNameBeginsWith)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListModelsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListModelsRequest.wrap(buildAwsValue())
}
object ListModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListModelsRequest =
      zio.aws.lookoutequipment.model.ListModelsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value),
        modelNameBeginsWith.map(value => value),
        datasetNameBeginsWith.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def status: Option[zio.aws.lookoutequipment.model.ModelStatus]
    def modelNameBeginsWith: Option[ModelName]
    def datasetNameBeginsWith: Option[DatasetName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getModelNameBeginsWith: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelNameBeginsWith", modelNameBeginsWith)
    def getDatasetNameBeginsWith: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetNameBeginsWith", datasetNameBeginsWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest
  ) extends zio.aws.lookoutequipment.model.ListModelsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val status: Option[zio.aws.lookoutequipment.model.ModelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val modelNameBeginsWith: Option[ModelName] = scala
      .Option(impl.modelNameBeginsWith())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val datasetNameBeginsWith: Option[DatasetName] = scala
      .Option(impl.datasetNameBeginsWith())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest
  ): zio.aws.lookoutequipment.model.ListModelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
