package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInferenceSchedulersResponse(
    nextToken: Option[NextToken] = None,
    inferenceSchedulerSummaries: Option[
      Iterable[zio.aws.lookoutequipment.model.InferenceSchedulerSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse = {
    import ListInferenceSchedulersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        inferenceSchedulerSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceSchedulerSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse
      .wrap(buildAwsValue())
}
object ListInferenceSchedulersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse =
      zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse(
        nextToken.map(value => value),
        inferenceSchedulerSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def inferenceSchedulerSummaries: Option[
      List[zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInferenceSchedulerSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceSchedulerSummaries",
      inferenceSchedulerSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ) extends zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val inferenceSchedulerSummaries: Option[
      List[zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly]
    ] = scala
      .Option(impl.inferenceSchedulerSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.InferenceSchedulerSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse
  ): zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly =
    new Wrapper(impl)
}
