package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DataDelayOffsetInMinutes,
  ModelArn,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InferenceSchedulerSummary(
    modelName: Option[ModelName] = None,
    modelArn: Option[ModelArn] = None,
    inferenceSchedulerName: Option[InferenceSchedulerName] = None,
    inferenceSchedulerArn: Option[InferenceSchedulerArn] = None,
    status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      None,
    dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes] = None,
    dataUploadFrequency: Option[
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary = {
    import InferenceSchedulerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .optionallyWith(dataUploadFrequency.map(value => value.unwrap))(
        _.dataUploadFrequency
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary
      .wrap(buildAwsValue())
}
object InferenceSchedulerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceSchedulerSummary =
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value),
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency.map(value => value)
      )
    def modelName: Option[ModelName]
    def modelArn: Option[ModelArn]
    def inferenceSchedulerName: Option[InferenceSchedulerName]
    def inferenceSchedulerArn: Option[InferenceSchedulerArn]
    def status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes]
    def dataUploadFrequency
        : Option[zio.aws.lookoutequipment.model.DataUploadFrequency]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = AwsError.unwrapOptionField("dataUploadFrequency", dataUploadFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ) extends zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly {
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val inferenceSchedulerName: Option[InferenceSchedulerName] = scala
      .Option(impl.inferenceSchedulerName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerName(value)
      )
    override val inferenceSchedulerArn: Option[InferenceSchedulerArn] = scala
      .Option(impl.inferenceSchedulerArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
      )
    override val status
        : Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
    override val dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes] =
      scala
        .Option(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : Option[zio.aws.lookoutequipment.model.DataUploadFrequency] = scala
      .Option(impl.dataUploadFrequency())
      .map(value =>
        zio.aws.lookoutequipment.model.DataUploadFrequency.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerSummary
  ): zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly =
    new Wrapper(impl)
}
