package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  BoundedLengthString,
  ModelArn,
  Timestamp,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InferenceExecutionSummary(
    modelName: Option[ModelName] = None,
    modelArn: Option[ModelArn] = None,
    inferenceSchedulerName: Option[InferenceSchedulerName] = None,
    inferenceSchedulerArn: Option[InferenceSchedulerArn] = None,
    scheduledStartTime: Option[Timestamp] = None,
    dataStartTime: Option[Timestamp] = None,
    dataEndTime: Option[Timestamp] = None,
    dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
    ] = None,
    dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
    ] = None,
    customerResultObject: Option[zio.aws.lookoutequipment.model.S3Object] =
      None,
    status: Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      None,
    failedReason: Option[BoundedLengthString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary = {
    import InferenceExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(
        scheduledStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledStartTime)
      .optionallyWith(
        dataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTime)
      .optionallyWith(
        dataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTime)
      .optionallyWith(
        dataInputConfiguration.map(value => value.buildAwsValue())
      )(_.dataInputConfiguration)
      .optionallyWith(
        dataOutputConfiguration.map(value => value.buildAwsValue())
      )(_.dataOutputConfiguration)
      .optionallyWith(customerResultObject.map(value => value.buildAwsValue()))(
        _.customerResultObject
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly =
    zio.aws.lookoutequipment.model.InferenceExecutionSummary
      .wrap(buildAwsValue())
}
object InferenceExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.InferenceExecutionSummary =
      zio.aws.lookoutequipment.model.InferenceExecutionSummary(
        modelName.map(value => value),
        modelArn.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        scheduledStartTime.map(value => value),
        dataStartTime.map(value => value),
        dataEndTime.map(value => value),
        dataInputConfiguration.map(value => value.asEditable),
        dataOutputConfiguration.map(value => value.asEditable),
        customerResultObject.map(value => value.asEditable),
        status.map(value => value),
        failedReason.map(value => value)
      )
    def modelName: Option[ModelName]
    def modelArn: Option[ModelArn]
    def inferenceSchedulerName: Option[InferenceSchedulerName]
    def inferenceSchedulerArn: Option[InferenceSchedulerArn]
    def scheduledStartTime: Option[Timestamp]
    def dataStartTime: Option[Timestamp]
    def dataEndTime: Option[Timestamp]
    def dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ]
    def dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ]
    def customerResultObject
        : Option[zio.aws.lookoutequipment.model.S3Object.ReadOnly]
    def status: Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus]
    def failedReason: Option[BoundedLengthString]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getScheduledStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledStartTime", scheduledStartTime)
    def getDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTime", dataStartTime)
    def getDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTime", dataEndTime)
    def getDataInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataInputConfiguration",
      dataInputConfiguration
    )
    def getDataOutputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataOutputConfiguration",
      dataOutputConfiguration
    )
    def getCustomerResultObject
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("customerResultObject", customerResultObject)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ) extends zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly {
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val inferenceSchedulerName: Option[InferenceSchedulerName] = scala
      .Option(impl.inferenceSchedulerName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerName(value)
      )
    override val inferenceSchedulerArn: Option[InferenceSchedulerArn] = scala
      .Option(impl.inferenceSchedulerArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
      )
    override val scheduledStartTime: Option[Timestamp] = scala
      .Option(impl.scheduledStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataStartTime: Option[Timestamp] = scala
      .Option(impl.dataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTime: Option[Timestamp] = scala
      .Option(impl.dataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputConfiguration.wrap(value)
      )
    override val dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataOutputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceOutputConfiguration.wrap(value)
      )
    override val customerResultObject
        : Option[zio.aws.lookoutequipment.model.S3Object.ReadOnly] = scala
      .Option(impl.customerResultObject())
      .map(value => zio.aws.lookoutequipment.model.S3Object.wrap(value))
    override val status
        : Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceExecutionStatus.wrap(value)
        )
    override val failedReason: Option[BoundedLengthString] = scala
      .Option(impl.failedReason())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary
  ): zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly =
    new Wrapper(impl)
}
