package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  BoundedLengthString,
  DatasetArn,
  OffCondition,
  ModelArn,
  Timestamp,
  ModelMetrics,
  DatasetName,
  ModelName,
  KmsKeyArn,
  InlineDataSchema
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeModelResponse(
    modelName: Option[ModelName] = None,
    modelArn: Option[ModelArn] = None,
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    schema: Option[InlineDataSchema] = None,
    labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = None,
    trainingDataStartTime: Option[Timestamp] = None,
    trainingDataEndTime: Option[Timestamp] = None,
    evaluationDataStartTime: Option[Timestamp] = None,
    evaluationDataEndTime: Option[Timestamp] = None,
    roleArn: Option[IamRoleArn] = None,
    dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
    ] = None,
    status: Option[zio.aws.lookoutequipment.model.ModelStatus] = None,
    trainingExecutionStartTime: Option[Timestamp] = None,
    trainingExecutionEndTime: Option[Timestamp] = None,
    failedReason: Option[BoundedLengthString] = None,
    modelMetrics: Option[ModelMetrics] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    createdAt: Option[Timestamp] = None,
    serverSideKmsKeyId: Option[KmsKeyArn] = None,
    offCondition: Option[OffCondition] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse = {
    import DescribeModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        schema.map(value => InlineDataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .optionallyWith(
        trainingDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataStartTime)
      .optionallyWith(
        trainingDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataEndTime)
      .optionallyWith(
        evaluationDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataStartTime)
      .optionallyWith(
        evaluationDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataEndTime)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        dataPreProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.dataPreProcessingConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        trainingExecutionStartTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.trainingExecutionStartTime)
      .optionallyWith(
        trainingExecutionEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingExecutionEndTime)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .optionallyWith(
        modelMetrics.map(value => ModelMetrics.unwrap(value): java.lang.String)
      )(_.modelMetrics)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        offCondition.map(value => OffCondition.unwrap(value): java.lang.String)
      )(_.offCondition)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeModelResponse.wrap(buildAwsValue())
}
object DescribeModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeModelResponse =
      zio.aws.lookoutequipment.model.DescribeModelResponse(
        modelName.map(value => value),
        modelArn.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        schema.map(value => value),
        labelsInputConfiguration.map(value => value.asEditable),
        trainingDataStartTime.map(value => value),
        trainingDataEndTime.map(value => value),
        evaluationDataStartTime.map(value => value),
        evaluationDataEndTime.map(value => value),
        roleArn.map(value => value),
        dataPreProcessingConfiguration.map(value => value.asEditable),
        status.map(value => value),
        trainingExecutionStartTime.map(value => value),
        trainingExecutionEndTime.map(value => value),
        failedReason.map(value => value),
        modelMetrics.map(value => value),
        lastUpdatedTime.map(value => value),
        createdAt.map(value => value),
        serverSideKmsKeyId.map(value => value),
        offCondition.map(value => value)
      )
    def modelName: Option[ModelName]
    def modelArn: Option[ModelArn]
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def schema: Option[InlineDataSchema]
    def labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def trainingDataStartTime: Option[Timestamp]
    def trainingDataEndTime: Option[Timestamp]
    def evaluationDataStartTime: Option[Timestamp]
    def evaluationDataEndTime: Option[Timestamp]
    def roleArn: Option[IamRoleArn]
    def dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ]
    def status: Option[zio.aws.lookoutequipment.model.ModelStatus]
    def trainingExecutionStartTime: Option[Timestamp]
    def trainingExecutionEndTime: Option[Timestamp]
    def failedReason: Option[BoundedLengthString]
    def modelMetrics: Option[ModelMetrics]
    def lastUpdatedTime: Option[Timestamp]
    def createdAt: Option[Timestamp]
    def serverSideKmsKeyId: Option[KmsKeyArn]
    def offCondition: Option[OffCondition]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getTrainingDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataStartTime", trainingDataStartTime)
    def getTrainingDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataEndTime", trainingDataEndTime)
    def getEvaluationDataStartTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("evaluationDataStartTime", evaluationDataStartTime)
    def getEvaluationDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("evaluationDataEndTime", evaluationDataEndTime)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPreProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataPreProcessingConfiguration",
      dataPreProcessingConfiguration
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.ModelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTrainingExecutionStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "trainingExecutionStartTime",
        trainingExecutionStartTime
      )
    def getTrainingExecutionEndTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("trainingExecutionEndTime", trainingExecutionEndTime)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
    def getModelMetrics: ZIO[Any, AwsError, ModelMetrics] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getOffCondition: ZIO[Any, AwsError, OffCondition] =
      AwsError.unwrapOptionField("offCondition", offCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ) extends zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly {
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val schema: Option[InlineDataSchema] = scala
      .Option(impl.schema())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
      )
    override val labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val trainingDataStartTime: Option[Timestamp] = scala
      .Option(impl.trainingDataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val trainingDataEndTime: Option[Timestamp] = scala
      .Option(impl.trainingDataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val evaluationDataStartTime: Option[Timestamp] = scala
      .Option(impl.evaluationDataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val evaluationDataEndTime: Option[Timestamp] = scala
      .Option(impl.evaluationDataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val roleArn: Option[IamRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataPreProcessingConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
          .wrap(value)
      )
    override val status: Option[zio.aws.lookoutequipment.model.ModelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutequipment.model.ModelStatus.wrap(value))
    override val trainingExecutionStartTime: Option[Timestamp] = scala
      .Option(impl.trainingExecutionStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val trainingExecutionEndTime: Option[Timestamp] = scala
      .Option(impl.trainingExecutionEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val failedReason: Option[BoundedLengthString] = scala
      .Option(impl.failedReason())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
      )
    override val modelMetrics: Option[ModelMetrics] = scala
      .Option(impl.modelMetrics())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.ModelMetrics(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val serverSideKmsKeyId: Option[KmsKeyArn] = scala
      .Option(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val offCondition: Option[OffCondition] = scala
      .Option(impl.offCondition())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.OffCondition(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse
  ): zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly =
    new Wrapper(impl)
}
