package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  DataDelayOffsetInMinutes,
  ModelArn,
  Timestamp,
  InferenceSchedulerName,
  InferenceSchedulerArn,
  ModelName,
  KmsKeyArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeInferenceSchedulerResponse(
    modelArn: Option[ModelArn] = None,
    modelName: Option[ModelName] = None,
    inferenceSchedulerName: Option[InferenceSchedulerName] = None,
    inferenceSchedulerArn: Option[InferenceSchedulerArn] = None,
    status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      None,
    dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes] = None,
    dataUploadFrequency: Option[
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration
    ] = None,
    dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration
    ] = None,
    roleArn: Option[IamRoleArn] = None,
    serverSideKmsKeyId: Option[KmsKeyArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse = {
    import DescribeInferenceSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        dataDelayOffsetInMinutes.map(value =>
          DataDelayOffsetInMinutes.unwrap(value): java.lang.Long
        )
      )(_.dataDelayOffsetInMinutes)
      .optionallyWith(dataUploadFrequency.map(value => value.unwrap))(
        _.dataUploadFrequency
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        dataInputConfiguration.map(value => value.buildAwsValue())
      )(_.dataInputConfiguration)
      .optionallyWith(
        dataOutputConfiguration.map(value => value.buildAwsValue())
      )(_.dataOutputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse
      .wrap(buildAwsValue())
}
object DescribeInferenceSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse =
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse(
        modelArn.map(value => value),
        modelName.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value),
        dataDelayOffsetInMinutes.map(value => value),
        dataUploadFrequency.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        dataInputConfiguration.map(value => value.asEditable),
        dataOutputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value),
        serverSideKmsKeyId.map(value => value)
      )
    def modelArn: Option[ModelArn]
    def modelName: Option[ModelName]
    def inferenceSchedulerName: Option[InferenceSchedulerName]
    def inferenceSchedulerArn: Option[InferenceSchedulerArn]
    def status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes]
    def dataUploadFrequency
        : Option[zio.aws.lookoutequipment.model.DataUploadFrequency]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ]
    def dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ]
    def roleArn: Option[IamRoleArn]
    def serverSideKmsKeyId: Option[KmsKeyArn]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getDataDelayOffsetInMinutes
        : ZIO[Any, AwsError, DataDelayOffsetInMinutes] = AwsError
      .unwrapOptionField("dataDelayOffsetInMinutes", dataDelayOffsetInMinutes)
    def getDataUploadFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataUploadFrequency
    ] = AwsError.unwrapOptionField("dataUploadFrequency", dataUploadFrequency)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDataInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataInputConfiguration",
      dataInputConfiguration
    )
    def getDataOutputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataOutputConfiguration",
      dataOutputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly {
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val inferenceSchedulerName: Option[InferenceSchedulerName] = scala
      .Option(impl.inferenceSchedulerName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerName(value)
      )
    override val inferenceSchedulerArn: Option[InferenceSchedulerArn] = scala
      .Option(impl.inferenceSchedulerArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
      )
    override val status
        : Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
    override val dataDelayOffsetInMinutes: Option[DataDelayOffsetInMinutes] =
      scala
        .Option(impl.dataDelayOffsetInMinutes())
        .map(value =>
          zio.aws.lookoutequipment.model.primitives
            .DataDelayOffsetInMinutes(value)
        )
    override val dataUploadFrequency
        : Option[zio.aws.lookoutequipment.model.DataUploadFrequency] = scala
      .Option(impl.dataUploadFrequency())
      .map(value =>
        zio.aws.lookoutequipment.model.DataUploadFrequency.wrap(value)
      )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataInputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceInputConfiguration.wrap(value)
      )
    override val dataOutputConfiguration: Option[
      zio.aws.lookoutequipment.model.InferenceOutputConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataOutputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.InferenceOutputConfiguration.wrap(value)
      )
    override val roleArn: Option[IamRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val serverSideKmsKeyId: Option[KmsKeyArn] = scala
      .Option(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse
  ): zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
