package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.DatasetIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(datasetName: DatasetIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest
      .builder()
      .datasetName(DatasetIdentifier.unwrap(datasetName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeDatasetRequest =
      zio.aws.lookoutequipment.model.DescribeDatasetRequest(datasetName)
    def datasetName: DatasetIdentifier
    def getDatasetName: ZIO[Any, Nothing, DatasetIdentifier] =
      ZIO.succeed(datasetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest
  ) extends zio.aws.lookoutequipment.model.DescribeDatasetRequest.ReadOnly {
    override val datasetName: DatasetIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .DatasetIdentifier(impl.datasetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest
  ): zio.aws.lookoutequipment.model.DescribeDatasetRequest.ReadOnly =
    new Wrapper(impl)
}
