package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  BoundedLengthString,
  DatasetArn,
  Timestamp,
  IngestionJobId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeDataIngestionJobResponse(
    jobId: Option[IngestionJobId] = None,
    datasetArn: Option[DatasetArn] = None,
    ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
    ] = None,
    roleArn: Option[IamRoleArn] = None,
    createdAt: Option[Timestamp] = None,
    status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = None,
    failedReason: Option[BoundedLengthString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse = {
    import DescribeDataIngestionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => IngestionJobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        ingestionInputConfiguration.map(value => value.buildAwsValue())
      )(_.ingestionInputConfiguration)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failedReason.map(value =>
          BoundedLengthString.unwrap(value): java.lang.String
        )
      )(_.failedReason)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse
      .wrap(buildAwsValue())
}
object DescribeDataIngestionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse =
      zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse(
        jobId.map(value => value),
        datasetArn.map(value => value),
        ingestionInputConfiguration.map(value => value.asEditable),
        roleArn.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        failedReason.map(value => value)
      )
    def jobId: Option[IngestionJobId]
    def datasetArn: Option[DatasetArn]
    def ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ]
    def roleArn: Option[IamRoleArn]
    def createdAt: Option[Timestamp]
    def status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus]
    def failedReason: Option[BoundedLengthString]
    def getJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getIngestionInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingestionInputConfiguration",
      ingestionInputConfiguration
    )
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionJobStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailedReason: ZIO[Any, AwsError, BoundedLengthString] =
      AwsError.unwrapOptionField("failedReason", failedReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ) extends zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly {
    override val jobId: Option[IngestionJobId] = scala
      .Option(impl.jobId())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.ingestionInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionInputConfiguration.wrap(value)
      )
    override val roleArn: Option[IamRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionJobStatus.wrap(value)
      )
    override val failedReason: Option[BoundedLengthString] = scala
      .Option(impl.failedReason())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.BoundedLengthString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse
  ): zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly =
    new Wrapper(impl)
}
