package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.IngestionJobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDataIngestionJobRequest(jobId: IngestionJobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest = {
    import DescribeDataIngestionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest
      .builder()
      .jobId(IngestionJobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest
      .wrap(buildAwsValue())
}
object DescribeDataIngestionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest =
      zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest(jobId)
    def jobId: IngestionJobId
    def getJobId: ZIO[Any, Nothing, IngestionJobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest
  ) extends zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest.ReadOnly {
    override val jobId: IngestionJobId =
      zio.aws.lookoutequipment.model.primitives.IngestionJobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest
  ): zio.aws.lookoutequipment.model.DescribeDataIngestionJobRequest.ReadOnly =
    new Wrapper(impl)
}
