package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DatasetArn,
  DatasetName,
  IngestionJobId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataIngestionJobSummary(
    jobId: Option[IngestionJobId] = None,
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
    ] = None,
    status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary = {
    import DataIngestionJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary
      .builder()
      .optionallyWith(
        jobId.map(value => IngestionJobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        ingestionInputConfiguration.map(value => value.buildAwsValue())
      )(_.ingestionInputConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly =
    zio.aws.lookoutequipment.model.DataIngestionJobSummary.wrap(buildAwsValue())
}
object DataIngestionJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DataIngestionJobSummary =
      zio.aws.lookoutequipment.model.DataIngestionJobSummary(
        jobId.map(value => value),
        datasetName.map(value => value),
        datasetArn.map(value => value),
        ingestionInputConfiguration.map(value => value.asEditable),
        status.map(value => value)
      )
    def jobId: Option[IngestionJobId]
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ]
    def status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus]
    def getJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getIngestionInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingestionInputConfiguration",
      ingestionInputConfiguration
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionJobStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary
  ) extends zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly {
    override val jobId: Option[IngestionJobId] = scala
      .Option(impl.jobId())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
      )
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.ingestionInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionInputConfiguration.wrap(value)
      )
    override val status
        : Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionJobStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary
  ): zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly =
    new Wrapper(impl)
}
