package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{DatasetArn, DatasetName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDatasetResponse(
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    status: Option[zio.aws.lookoutequipment.model.DatasetStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly =
    zio.aws.lookoutequipment.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateDatasetResponse =
      zio.aws.lookoutequipment.model.CreateDatasetResponse(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value)
      )
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def status: Option[zio.aws.lookoutequipment.model.DatasetStatus]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse
  ) extends zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly {
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val status: Option[zio.aws.lookoutequipment.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutequipment.model.DatasetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse
  ): zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly =
    new Wrapper(impl)
}
