package zio.aws.lookoutequipment
import zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly
import zio.aws.lookoutequipment.model.{
  CreateDatasetRequest,
  StartInferenceSchedulerRequest,
  CreateInferenceSchedulerRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DescribeInferenceSchedulerRequest,
  ListInferenceSchedulersRequest,
  ListDatasetsRequest,
  ListModelsRequest,
  UpdateInferenceSchedulerRequest,
  DeleteDatasetRequest,
  DeleteInferenceSchedulerRequest,
  StartDataIngestionJobRequest,
  UntagResourceRequest,
  ListInferenceExecutionsRequest,
  DescribeDataIngestionJobRequest,
  DeleteModelRequest,
  ListDataIngestionJobsRequest,
  StopInferenceSchedulerRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object LookoutEquipmentMock extends Mock[LookoutEquipment] {
  object ListInferenceExecutions
      extends Stream[
        ListInferenceExecutionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
      ]
  object ListInferenceExecutionsPaginated
      extends Effect[
        ListInferenceExecutionsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
      ]
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
      ]
  object ListModels
      extends Stream[
        ListModelsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
      ]
  object ListModelsPaginated
      extends Effect[ListModelsRequest, AwsError, ReadOnly]
  object StartInferenceScheduler
      extends Effect[
        StartInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
      ]
  object StopInferenceScheduler
      extends Effect[
        StopInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
      ]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
      ]
  object DeleteModel extends Effect[DeleteModelRequest, AwsError, Unit]
  object CreateInferenceScheduler
      extends Effect[
        CreateInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeInferenceScheduler
      extends Effect[
        DescribeInferenceSchedulerRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
      ]
  object DeleteInferenceScheduler
      extends Effect[DeleteInferenceSchedulerRequest, AwsError, Unit]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateInferenceScheduler
      extends Effect[UpdateInferenceSchedulerRequest, AwsError, Unit]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
      ]
  object DeleteDataset extends Effect[DeleteDatasetRequest, AwsError, Unit]
  object StartDataIngestionJob
      extends Effect[
        StartDataIngestionJobRequest,
        AwsError,
        zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
      ]
  object ListInferenceSchedulers
      extends Stream[
        ListInferenceSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
      ]
  object ListInferenceSchedulersPaginated
      extends Effect[
        ListInferenceSchedulersRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
      ]
  object DescribeDataIngestionJob
      extends Effect[
        DescribeDataIngestionJobRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
      ]
  object ListDataIngestionJobs
      extends Stream[
        ListDataIngestionJobsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
      ]
  object ListDataIngestionJobsPaginated
      extends Effect[
        ListDataIngestionJobsRequest,
        AwsError,
        zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
      ]
  object DescribeModel
      extends Effect[
        DescribeModelRequest,
        AwsError,
        zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LookoutEquipment] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new LookoutEquipment {
          val api: LookoutEquipmentAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : LookoutEquipment = this
          def listInferenceExecutions(
              request: ListInferenceExecutionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListInferenceExecutions, request))
          def listInferenceExecutionsPaginated(
              request: ListInferenceExecutionsRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
          ] = proxy(ListInferenceExecutionsPaginated, request)
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def listModels(request: ListModelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListModels, request))
          def listModelsPaginated(
              request: ListModelsRequest
          ): IO[AwsError, ReadOnly] = proxy(ListModelsPaginated, request)
          def startInferenceScheduler(
              request: StartInferenceSchedulerRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
          ] = proxy(StartInferenceScheduler, request)
          def createModel(request: CreateModelRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
          ] = proxy(CreateModel, request)
          def stopInferenceScheduler(
              request: StopInferenceSchedulerRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
          ] = proxy(StopInferenceScheduler, request)
          def describeDataset(request: DescribeDatasetRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
          ] = proxy(DescribeDataset, request)
          def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
            proxy(DeleteModel, request)
          def createInferenceScheduler(
              request: CreateInferenceSchedulerRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
          ] = proxy(CreateInferenceScheduler, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def describeInferenceScheduler(
              request: DescribeInferenceSchedulerRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
          ] = proxy(DescribeInferenceScheduler, request)
          def deleteInferenceScheduler(
              request: DeleteInferenceSchedulerRequest
          ): IO[AwsError, Unit] = proxy(DeleteInferenceScheduler, request)
          def listDatasets(request: ListDatasetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDatasets, request))
          def listDatasetsPaginated(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasetsPaginated, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def updateInferenceScheduler(
              request: UpdateInferenceSchedulerRequest
          ): IO[AwsError, Unit] = proxy(UpdateInferenceScheduler, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
            proxy(DeleteDataset, request)
          def startDataIngestionJob(request: StartDataIngestionJobRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
          ] = proxy(StartDataIngestionJob, request)
          def listInferenceSchedulers(
              request: ListInferenceSchedulersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListInferenceSchedulers, request))
          def listInferenceSchedulersPaginated(
              request: ListInferenceSchedulersRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
          ] = proxy(ListInferenceSchedulersPaginated, request)
          def describeDataIngestionJob(
              request: DescribeDataIngestionJobRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
          ] = proxy(DescribeDataIngestionJob, request)
          def listDataIngestionJobs(
              request: ListDataIngestionJobsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataIngestionJobs, request))
          def listDataIngestionJobsPaginated(
              request: ListDataIngestionJobsRequest
          ): IO[
            AwsError,
            zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
          ] = proxy(ListDataIngestionJobsPaginated, request)
          def describeModel(request: DescribeModelRequest): IO[
            AwsError,
            zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
          ] = proxy(DescribeModel, request)
        }
      }
    }
    .toLayer
}
