package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  InferenceSchedulerArn,
  InferenceSchedulerName,
  ModelName,
  ModelArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartInferenceSchedulerResponse(
    modelArn: Option[ModelArn] = None,
    modelName: Option[ModelName] = None,
    inferenceSchedulerName: Option[InferenceSchedulerName] = None,
    inferenceSchedulerArn: Option[InferenceSchedulerArn] = None,
    status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse = {
    import StartInferenceSchedulerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        inferenceSchedulerName.map(value =>
          InferenceSchedulerName.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerName)
      .optionallyWith(
        inferenceSchedulerArn.map(value =>
          InferenceSchedulerArn.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly =
    zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse
      .wrap(buildAwsValue())
}
object StartInferenceSchedulerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse =
      zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse(
        modelArn.map(value => value),
        modelName.map(value => value),
        inferenceSchedulerName.map(value => value),
        inferenceSchedulerArn.map(value => value),
        status.map(value => value)
      )
    def modelArn: Option[ModelArn]
    def modelName: Option[ModelName]
    def inferenceSchedulerName: Option[InferenceSchedulerName]
    def inferenceSchedulerArn: Option[InferenceSchedulerArn]
    def status: Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus]
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getInferenceSchedulerName: ZIO[Any, AwsError, InferenceSchedulerName] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerName",
        inferenceSchedulerName
      )
    def getInferenceSchedulerArn: ZIO[Any, AwsError, InferenceSchedulerArn] =
      AwsError.unwrapOptionField("inferenceSchedulerArn", inferenceSchedulerArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse
  ) extends zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly {
    override val modelArn: Option[ModelArn] = scala
      .Option(impl.modelArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelArn(value))
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
    override val inferenceSchedulerName: Option[InferenceSchedulerName] = scala
      .Option(impl.inferenceSchedulerName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerName(value)
      )
    override val inferenceSchedulerArn: Option[InferenceSchedulerArn] = scala
      .Option(impl.inferenceSchedulerArn())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InferenceSchedulerArn(value)
      )
    override val status
        : Option[zio.aws.lookoutequipment.model.InferenceSchedulerStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceSchedulerStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse
  ): zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly =
    new Wrapper(impl)
}
