package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.lookoutequipment.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListTagsForResourceResponse =
      zio.aws.lookoutequipment.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Option[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse
  ) extends zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly {
    override val tags
        : Option[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse
  ): zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
