package zio.aws.lookoutequipment.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lookoutequipment.model.primitives.{
  Timestamp,
  InferenceSchedulerIdentifier,
  MaxResults,
  NextToken
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListInferenceExecutionsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    inferenceSchedulerName: InferenceSchedulerIdentifier,
    dataStartTimeAfter: Option[Timestamp] = None,
    dataEndTimeBefore: Option[Timestamp] = None,
    status: Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest = {
    import ListInferenceExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .optionallyWith(
        dataStartTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataStartTimeAfter)
      .optionallyWith(
        dataEndTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.dataEndTimeBefore)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest
      .wrap(buildAwsValue())
}
object ListInferenceExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest =
      zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        inferenceSchedulerName,
        dataStartTimeAfter.map(value => value),
        dataEndTimeBefore.map(value => value),
        status.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def dataStartTimeAfter: Option[Timestamp]
    def dataEndTimeBefore: Option[Timestamp]
    def status: Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
    def getDataStartTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataStartTimeAfter", dataStartTimeAfter)
    def getDataEndTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dataEndTimeBefore", dataEndTimeBefore)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ) extends zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
    override val dataStartTimeAfter: Option[Timestamp] = scala
      .Option(impl.dataStartTimeAfter())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val dataEndTimeBefore: Option[Timestamp] = scala
      .Option(impl.dataEndTimeBefore())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status
        : Option[zio.aws.lookoutequipment.model.InferenceExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.lookoutequipment.model.InferenceExecutionStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest
  ): zio.aws.lookoutequipment.model.ListInferenceExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
