package zio.aws.lookoutequipment.model
import java.lang.Integer
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DatasetName,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDatasetsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    datasetNameBeginsWith: Option[DatasetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest = {
    import ListDatasetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        datasetNameBeginsWith.map(value =>
          DatasetName.unwrap(value): java.lang.String
        )
      )(_.datasetNameBeginsWith)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListDatasetsRequest.wrap(buildAwsValue())
}
object ListDatasetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.ListDatasetsRequest =
      zio.aws.lookoutequipment.model.ListDatasetsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        datasetNameBeginsWith.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def datasetNameBeginsWith: Option[DatasetName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDatasetNameBeginsWith: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetNameBeginsWith", datasetNameBeginsWith)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ) extends zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val datasetNameBeginsWith: Option[DatasetName] = scala
      .Option(impl.datasetNameBeginsWith())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest
  ): zio.aws.lookoutequipment.model.ListDatasetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
