package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDataIngestionJobsResponse(
    nextToken: Option[NextToken] = None,
    dataIngestionJobSummaries: Option[
      Iterable[zio.aws.lookoutequipment.model.DataIngestionJobSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse = {
    import ListDataIngestionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        dataIngestionJobSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataIngestionJobSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse
      .wrap(buildAwsValue())
}
object ListDataIngestionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse =
      zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse(
        nextToken.map(value => value),
        dataIngestionJobSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def dataIngestionJobSummaries: Option[
      List[zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDataIngestionJobSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataIngestionJobSummaries",
      dataIngestionJobSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse
  ) extends zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val dataIngestionJobSummaries: Option[
      List[zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly]
    ] = scala
      .Option(impl.dataIngestionJobSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.DataIngestionJobSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse
  ): zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
