package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.InferenceSchedulerIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeInferenceSchedulerRequest(
    inferenceSchedulerName: InferenceSchedulerIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest = {
    import DescribeInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest
      .builder()
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object DescribeInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.DescribeInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model
        .DescribeInferenceSchedulerRequest(inferenceSchedulerName)
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.DescribeInferenceSchedulerRequest.ReadOnly {
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.DescribeInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
