package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  DatasetArn,
  Timestamp,
  DatasetName,
  KmsKeyArn,
  InlineDataSchema
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeDatasetResponse(
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    createdAt: Option[Timestamp] = None,
    lastUpdatedAt: Option[Timestamp] = None,
    status: Option[zio.aws.lookoutequipment.model.DatasetStatus] = None,
    schema: Option[InlineDataSchema] = None,
    serverSideKmsKeyId: Option[KmsKeyArn] = None,
    ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        schema.map(value => InlineDataSchema.unwrap(value): java.lang.String)
      )(_.schema)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        ingestionInputConfiguration.map(value => value.buildAwsValue())
      )(_.ingestionInputConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DescribeDatasetResponse =
      zio.aws.lookoutequipment.model.DescribeDatasetResponse(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        status.map(value => value),
        schema.map(value => value),
        serverSideKmsKeyId.map(value => value),
        ingestionInputConfiguration.map(value => value.asEditable)
      )
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def createdAt: Option[Timestamp]
    def lastUpdatedAt: Option[Timestamp]
    def status: Option[zio.aws.lookoutequipment.model.DatasetStatus]
    def schema: Option[InlineDataSchema]
    def serverSideKmsKeyId: Option[KmsKeyArn]
    def ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lookoutequipment.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSchema: ZIO[Any, AwsError, InlineDataSchema] =
      AwsError.unwrapOptionField("schema", schema)
    def getServerSideKmsKeyId: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getIngestionInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ingestionInputConfiguration",
      ingestionInputConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ) extends zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly {
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.DatasetName(value)
      )
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.DatasetArn(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Option[Timestamp] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.lookoutequipment.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.lookoutequipment.model.DatasetStatus.wrap(value))
    override val schema: Option[InlineDataSchema] = scala
      .Option(impl.schema())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.InlineDataSchema(value)
      )
    override val serverSideKmsKeyId: Option[KmsKeyArn] = scala
      .Option(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.KmsKeyArn(value))
    override val ingestionInputConfiguration: Option[
      zio.aws.lookoutequipment.model.IngestionInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.ingestionInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionInputConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse
  ): zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly =
    new Wrapper(impl)
}
