package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  IamRoleArn,
  OffCondition,
  NameOrArn,
  Timestamp,
  IdempotenceToken,
  ModelName,
  DatasetIdentifier
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateModelRequest(
    modelName: ModelName,
    datasetName: DatasetIdentifier,
    datasetSchema: Option[zio.aws.lookoutequipment.model.DatasetSchema] = None,
    labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration
    ] = None,
    clientToken: IdempotenceToken,
    trainingDataStartTime: Option[Timestamp] = None,
    trainingDataEndTime: Option[Timestamp] = None,
    evaluationDataStartTime: Option[Timestamp] = None,
    evaluationDataEndTime: Option[Timestamp] = None,
    roleArn: Option[IamRoleArn] = None,
    dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
    ] = None,
    serverSideKmsKeyId: Option[NameOrArn] = None,
    tags: Option[Iterable[zio.aws.lookoutequipment.model.Tag]] = None,
    offCondition: Option[OffCondition] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .datasetName(DatasetIdentifier.unwrap(datasetName): java.lang.String)
      .optionallyWith(datasetSchema.map(value => value.buildAwsValue()))(
        _.datasetSchema
      )
      .optionallyWith(
        labelsInputConfiguration.map(value => value.buildAwsValue())
      )(_.labelsInputConfiguration)
      .clientToken(IdempotenceToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        trainingDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataStartTime)
      .optionallyWith(
        trainingDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingDataEndTime)
      .optionallyWith(
        evaluationDataStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataStartTime)
      .optionallyWith(
        evaluationDataEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.evaluationDataEndTime)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        dataPreProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.dataPreProcessingConfiguration)
      .optionallyWith(
        serverSideKmsKeyId.map(value =>
          NameOrArn.unwrap(value): java.lang.String
        )
      )(_.serverSideKmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        offCondition.map(value => OffCondition.unwrap(value): java.lang.String)
      )(_.offCondition)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.CreateModelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.CreateModelRequest =
      zio.aws.lookoutequipment.model.CreateModelRequest(
        modelName,
        datasetName,
        datasetSchema.map(value => value.asEditable),
        labelsInputConfiguration.map(value => value.asEditable),
        clientToken,
        trainingDataStartTime.map(value => value),
        trainingDataEndTime.map(value => value),
        evaluationDataStartTime.map(value => value),
        evaluationDataEndTime.map(value => value),
        roleArn.map(value => value),
        dataPreProcessingConfiguration.map(value => value.asEditable),
        serverSideKmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        offCondition.map(value => value)
      )
    def modelName: ModelName
    def datasetName: DatasetIdentifier
    def datasetSchema
        : Option[zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly]
    def labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ]
    def clientToken: IdempotenceToken
    def trainingDataStartTime: Option[Timestamp]
    def trainingDataEndTime: Option[Timestamp]
    def evaluationDataStartTime: Option[Timestamp]
    def evaluationDataEndTime: Option[Timestamp]
    def roleArn: Option[IamRoleArn]
    def dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ]
    def serverSideKmsKeyId: Option[NameOrArn]
    def tags: Option[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]]
    def offCondition: Option[OffCondition]
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getDatasetName: ZIO[Any, Nothing, DatasetIdentifier] =
      ZIO.succeed(datasetName)
    def getDatasetSchema: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly
    ] = AwsError.unwrapOptionField("datasetSchema", datasetSchema)
    def getLabelsInputConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelsInputConfiguration",
      labelsInputConfiguration
    )
    def getClientToken: ZIO[Any, Nothing, IdempotenceToken] =
      ZIO.succeed(clientToken)
    def getTrainingDataStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataStartTime", trainingDataStartTime)
    def getTrainingDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingDataEndTime", trainingDataEndTime)
    def getEvaluationDataStartTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("evaluationDataStartTime", evaluationDataStartTime)
    def getEvaluationDataEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("evaluationDataEndTime", evaluationDataEndTime)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPreProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataPreProcessingConfiguration",
      dataPreProcessingConfiguration
    )
    def getServerSideKmsKeyId: ZIO[Any, AwsError, NameOrArn] =
      AwsError.unwrapOptionField("serverSideKmsKeyId", serverSideKmsKeyId)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getOffCondition: ZIO[Any, AwsError, OffCondition] =
      AwsError.unwrapOptionField("offCondition", offCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest
  ) extends zio.aws.lookoutequipment.model.CreateModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
    override val datasetName: DatasetIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .DatasetIdentifier(impl.datasetName())
    override val datasetSchema
        : Option[zio.aws.lookoutequipment.model.DatasetSchema.ReadOnly] = scala
      .Option(impl.datasetSchema())
      .map(value => zio.aws.lookoutequipment.model.DatasetSchema.wrap(value))
    override val labelsInputConfiguration: Option[
      zio.aws.lookoutequipment.model.LabelsInputConfiguration.ReadOnly
    ] = scala
      .Option(impl.labelsInputConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.LabelsInputConfiguration.wrap(value)
      )
    override val clientToken: IdempotenceToken =
      zio.aws.lookoutequipment.model.primitives
        .IdempotenceToken(impl.clientToken())
    override val trainingDataStartTime: Option[Timestamp] = scala
      .Option(impl.trainingDataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val trainingDataEndTime: Option[Timestamp] = scala
      .Option(impl.trainingDataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val evaluationDataStartTime: Option[Timestamp] = scala
      .Option(impl.evaluationDataStartTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val evaluationDataEndTime: Option[Timestamp] = scala
      .Option(impl.evaluationDataEndTime())
      .map(value => zio.aws.lookoutequipment.model.primitives.Timestamp(value))
    override val roleArn: Option[IamRoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lookoutequipment.model.primitives.IamRoleArn(value))
    override val dataPreProcessingConfiguration: Option[
      zio.aws.lookoutequipment.model.DataPreProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.dataPreProcessingConfiguration())
      .map(value =>
        zio.aws.lookoutequipment.model.DataPreProcessingConfiguration
          .wrap(value)
      )
    override val serverSideKmsKeyId: Option[NameOrArn] = scala
      .Option(impl.serverSideKmsKeyId())
      .map(value => zio.aws.lookoutequipment.model.primitives.NameOrArn(value))
    override val tags
        : Option[List[zio.aws.lookoutequipment.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.Tag.wrap(item)
        }.toList
      )
    override val offCondition: Option[OffCondition] = scala
      .Option(impl.offCondition())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.OffCondition(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest
  ): zio.aws.lookoutequipment.model.CreateModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
