package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{TagKey, AmazonResourceArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: AmazonResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest
      .builder()
      .resourceArn(AmazonResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.UntagResourceRequest.ReadOnly =
    zio.aws.lookoutequipment.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.UntagResourceRequest =
      zio.aws.lookoutequipment.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: AmazonResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest
  ) extends zio.aws.lookoutequipment.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceArn =
      zio.aws.lookoutequipment.model.primitives
        .AmazonResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.lookoutequipment.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest
  ): zio.aws.lookoutequipment.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
