package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.InferenceSchedulerIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopInferenceSchedulerRequest(
    inferenceSchedulerName: InferenceSchedulerIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest = {
    import StopInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest
      .builder()
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StopInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.StopInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object StopInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StopInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model
        .StopInferenceSchedulerRequest(inferenceSchedulerName)
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.StopInferenceSchedulerRequest.ReadOnly {
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.StopInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
