package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.InferenceSchedulerIdentifier
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartInferenceSchedulerRequest(
    inferenceSchedulerName: InferenceSchedulerIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest = {
    import StartInferenceSchedulerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest
      .builder()
      .inferenceSchedulerName(
        InferenceSchedulerIdentifier.unwrap(
          inferenceSchedulerName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StartInferenceSchedulerRequest.ReadOnly =
    zio.aws.lookoutequipment.model.StartInferenceSchedulerRequest
      .wrap(buildAwsValue())
}
object StartInferenceSchedulerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StartInferenceSchedulerRequest =
      zio.aws.lookoutequipment.model
        .StartInferenceSchedulerRequest(inferenceSchedulerName)
    def inferenceSchedulerName: InferenceSchedulerIdentifier
    def getInferenceSchedulerName
        : ZIO[Any, Nothing, InferenceSchedulerIdentifier] =
      ZIO.succeed(inferenceSchedulerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest
  ) extends zio.aws.lookoutequipment.model.StartInferenceSchedulerRequest.ReadOnly {
    override val inferenceSchedulerName: InferenceSchedulerIdentifier =
      zio.aws.lookoutequipment.model.primitives
        .InferenceSchedulerIdentifier(impl.inferenceSchedulerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest
  ): zio.aws.lookoutequipment.model.StartInferenceSchedulerRequest.ReadOnly =
    new Wrapper(impl)
}
