package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.IngestionJobId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartDataIngestionJobResponse(
    jobId: Option[IngestionJobId] = None,
    status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse = {
    import StartDataIngestionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => IngestionJobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly =
    zio.aws.lookoutequipment.model.StartDataIngestionJobResponse
      .wrap(buildAwsValue())
}
object StartDataIngestionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.StartDataIngestionJobResponse =
      zio.aws.lookoutequipment.model.StartDataIngestionJobResponse(
        jobId.map(value => value),
        status.map(value => value)
      )
    def jobId: Option[IngestionJobId]
    def status: Option[zio.aws.lookoutequipment.model.IngestionJobStatus]
    def getJobId: ZIO[Any, AwsError, IngestionJobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.IngestionJobStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse
  ) extends zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly {
    override val jobId: Option[IngestionJobId] = scala
      .Option(impl.jobId())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives.IngestionJobId(value)
      )
    override val status
        : Option[zio.aws.lookoutequipment.model.IngestionJobStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.lookoutequipment.model.IngestionJobStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse
  ): zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly =
    new Wrapper(impl)
}
