package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{S3Key, S3Bucket}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Object(bucket: S3Bucket, key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.S3Object
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.S3Object.ReadOnly =
    zio.aws.lookoutequipment.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.S3Object
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.S3Object =
      zio.aws.lookoutequipment.model.S3Object(bucket, key)
    def bucket: S3Bucket
    def key: S3Key
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.S3Object
  ) extends zio.aws.lookoutequipment.model.S3Object.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.lookoutequipment.model.primitives.S3Bucket(impl.bucket())
    override val key: S3Key =
      zio.aws.lookoutequipment.model.primitives.S3Key(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.S3Object
  ): zio.aws.lookoutequipment.model.S3Object.ReadOnly = new Wrapper(impl)
}
