package zio.aws.lookoutequipment.model
import java.lang.Integer
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.{
  ModelName,
  InferenceSchedulerIdentifier,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInferenceSchedulersRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    inferenceSchedulerNameBeginsWith: Option[InferenceSchedulerIdentifier] =
      None,
    modelName: Option[ModelName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest = {
    import ListInferenceSchedulersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        inferenceSchedulerNameBeginsWith.map(value =>
          InferenceSchedulerIdentifier.unwrap(value): java.lang.String
        )
      )(_.inferenceSchedulerNameBeginsWith)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest
      .wrap(buildAwsValue())
}
object ListInferenceSchedulersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest =
      zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        inferenceSchedulerNameBeginsWith.map(value => value),
        modelName.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def inferenceSchedulerNameBeginsWith: Option[InferenceSchedulerIdentifier]
    def modelName: Option[ModelName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getInferenceSchedulerNameBeginsWith
        : ZIO[Any, AwsError, InferenceSchedulerIdentifier] =
      AwsError.unwrapOptionField(
        "inferenceSchedulerNameBeginsWith",
        inferenceSchedulerNameBeginsWith
      )
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ) extends zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lookoutequipment.model.primitives.MaxResults(value))
    override val inferenceSchedulerNameBeginsWith
        : Option[InferenceSchedulerIdentifier] = scala
      .Option(impl.inferenceSchedulerNameBeginsWith())
      .map(value =>
        zio.aws.lookoutequipment.model.primitives
          .InferenceSchedulerIdentifier(value)
      )
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.lookoutequipment.model.primitives.ModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest
  ): zio.aws.lookoutequipment.model.ListInferenceSchedulersRequest.ReadOnly =
    new Wrapper(impl)
}
