package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInferenceExecutionsResponse(
    nextToken: Option[NextToken] = None,
    inferenceExecutionSummaries: Option[
      Iterable[zio.aws.lookoutequipment.model.InferenceExecutionSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse = {
    import ListInferenceExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        inferenceExecutionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceExecutionSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly =
    zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse
      .wrap(buildAwsValue())
}
object ListInferenceExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse =
      zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse(
        nextToken.map(value => value),
        inferenceExecutionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def inferenceExecutionSummaries: Option[
      List[zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getInferenceExecutionSummaries: ZIO[Any, AwsError, List[
      zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceExecutionSummaries",
      inferenceExecutionSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse
  ) extends zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lookoutequipment.model.primitives.NextToken(value))
    override val inferenceExecutionSummaries: Option[
      List[zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly]
    ] = scala
      .Option(impl.inferenceExecutionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lookoutequipment.model.InferenceExecutionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse
  ): zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
