package zio.aws.lookoutequipment.model
import zio.ZIO
import zio.aws.lookoutequipment.model.primitives.ModelName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest = {
    import DeleteModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lookoutequipment.model.DeleteModelRequest.ReadOnly =
    zio.aws.lookoutequipment.model.DeleteModelRequest.wrap(buildAwsValue())
}
object DeleteModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lookoutequipment.model.DeleteModelRequest =
      zio.aws.lookoutequipment.model.DeleteModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest
  ) extends zio.aws.lookoutequipment.model.DeleteModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.lookoutequipment.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest
  ): zio.aws.lookoutequipment.model.DeleteModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
