package zio.aws.lookoutequipment
import zio.aws.lookoutequipment.model.ListModelsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.lookoutequipment.model.{
  CreateDatasetRequest,
  StartInferenceSchedulerRequest,
  CreateInferenceSchedulerRequest,
  DescribeDatasetRequest,
  DescribeModelRequest,
  ListTagsForResourceRequest,
  CreateModelRequest,
  DescribeInferenceSchedulerRequest,
  ListInferenceSchedulersRequest,
  ListDatasetsRequest,
  ListModelsRequest,
  UpdateInferenceSchedulerRequest,
  DeleteDatasetRequest,
  DeleteInferenceSchedulerRequest,
  StartDataIngestionJobRequest,
  UntagResourceRequest,
  ListInferenceExecutionsRequest,
  DescribeDataIngestionJobRequest,
  DeleteModelRequest,
  ListDataIngestionJobsRequest,
  StopInferenceSchedulerRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.lookoutequipment.{
  LookoutEquipmentAsyncClientBuilder,
  LookoutEquipmentAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lookoutequipment.model.{
  InferenceSchedulerSummary,
  ModelSummary,
  DatasetSummary,
  DataIngestionJobSummary,
  DescribeDatasetResponse,
  ListInferenceExecutionsResponse,
  CreateInferenceSchedulerResponse,
  ListInferenceSchedulersResponse,
  CreateDatasetResponse,
  StartDataIngestionJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteModelResponse,
  StopInferenceSchedulerResponse,
  DescribeDataIngestionJobResponse,
  DeleteDatasetResponse,
  ListModelsResponse,
  ListDataIngestionJobsResponse,
  CreateModelResponse,
  UpdateInferenceSchedulerResponse,
  InferenceExecutionSummary,
  StartInferenceSchedulerResponse,
  ListDatasetsResponse,
  DescribeModelResponse,
  DeleteInferenceSchedulerResponse,
  DescribeInferenceSchedulerResponse,
  TagResourceResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait LookoutEquipment extends AspectSupport[LookoutEquipment] {
  val api: LookoutEquipmentAsyncClient
  def listInferenceExecutions(request: ListInferenceExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
  ]
  def listInferenceExecutionsPaginated(
      request: ListInferenceExecutionsRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
  ]
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly]
  def listModels(request: ListModelsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
  ]
  def listModelsPaginated(request: ListModelsRequest): IO[AwsError, ReadOnly]
  def startInferenceScheduler(request: StartInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
  ]
  def createModel(
      request: CreateModelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly]
  def stopInferenceScheduler(request: StopInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
  ]
  def describeDataset(request: DescribeDatasetRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
  ]
  def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit]
  def createInferenceScheduler(request: CreateInferenceSchedulerRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly]
  def describeInferenceScheduler(
      request: DescribeInferenceSchedulerRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
  ]
  def deleteInferenceScheduler(
      request: DeleteInferenceSchedulerRequest
  ): IO[AwsError, Unit]
  def listDatasets(request: ListDatasetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
  ]
  def listDatasetsPaginated(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateInferenceScheduler(
      request: UpdateInferenceSchedulerRequest
  ): IO[AwsError, Unit]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly]
  def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit]
  def startDataIngestionJob(request: StartDataIngestionJobRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
  ]
  def listInferenceSchedulers(request: ListInferenceSchedulersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
  ]
  def listInferenceSchedulersPaginated(
      request: ListInferenceSchedulersRequest
  ): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
  ]
  def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
  ]
  def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
  ]
  def listDataIngestionJobsPaginated(request: ListDataIngestionJobsRequest): IO[
    AwsError,
    zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
  ]
  def describeModel(
      request: DescribeModelRequest
  ): IO[AwsError, zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly]
}
object LookoutEquipment {
  val live: ZLayer[AwsConfig, java.lang.Throwable, LookoutEquipment] =
    customized(identity)
  def customized(
      customization: LookoutEquipmentAsyncClientBuilder => LookoutEquipmentAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, LookoutEquipment] = managed(
    customization
  ).toLayer
  def managed(
      customization: LookoutEquipmentAsyncClientBuilder => LookoutEquipmentAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, LookoutEquipment] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = LookoutEquipmentAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        LookoutEquipmentAsyncClient,
        LookoutEquipmentAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        LookoutEquipmentAsyncClient,
        LookoutEquipmentAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new LookoutEquipmentImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class LookoutEquipmentImpl[R](
      override val api: LookoutEquipmentAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends LookoutEquipment
      with AwsServiceBase[R] {
    override val serviceName: String = "LookoutEquipment"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LookoutEquipmentImpl[R1] = new LookoutEquipmentImpl(api, newAspect, r)
    def listInferenceExecutions(
        request: ListInferenceExecutionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest,
      ListInferenceExecutionsResponse,
      InferenceExecutionSummary
    ](
      "listInferenceExecutions",
      api.listInferenceExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceExecutionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.InferenceExecutionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceExecutionsPaginated(
        request: ListInferenceExecutionsRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest,
      ListInferenceExecutionsResponse
    ]("listInferenceExecutions", api.listInferenceExecutions)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.wrap)
      .provideEnvironment(r)
    def createDataset(request: CreateDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest,
      CreateDatasetResponse
    ]("createDataset", api.createDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateDatasetResponse.wrap)
      .provideEnvironment(r)
    def listModels(request: ListModelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest,
      ListModelsResponse,
      ModelSummary
    ](
      "listModels",
      api.listModels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.modelSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.ModelSummary.wrap(item))
      .provideEnvironment(r)
    def listModelsPaginated(
        request: ListModelsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest,
      ListModelsResponse
    ]("listModels", api.listModels)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListModelsResponse.wrap)
      .provideEnvironment(r)
    def startInferenceScheduler(request: StartInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest,
      StartInferenceSchedulerResponse
    ]("startInferenceScheduler", api.startInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def createModel(request: CreateModelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest,
      CreateModelResponse
    ]("createModel", api.createModel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.CreateModelResponse.wrap)
      .provideEnvironment(r)
    def stopInferenceScheduler(request: StopInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest,
      StopInferenceSchedulerResponse
    ]("stopInferenceScheduler", api.stopInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def describeDataset(request: DescribeDatasetRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest,
      DescribeDatasetResponse
    ]("describeDataset", api.describeDataset)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeDatasetResponse.wrap)
      .provideEnvironment(r)
    def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest,
        DeleteModelResponse
      ]("deleteModel", api.deleteModel)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createInferenceScheduler(request: CreateInferenceSchedulerRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest,
      CreateInferenceSchedulerResponse
    ]("createInferenceScheduler", api.createInferenceScheduler)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeInferenceScheduler(
        request: DescribeInferenceSchedulerRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest,
      DescribeInferenceSchedulerResponse
    ]("describeInferenceScheduler", api.describeInferenceScheduler)(
      request.buildAwsValue()
    ).map(
      zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.wrap
    ).provideEnvironment(r)
    def deleteInferenceScheduler(
        request: DeleteInferenceSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest,
      DeleteInferenceSchedulerResponse
    ]("deleteInferenceScheduler", api.deleteInferenceScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listDatasets(request: ListDatasetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest,
      ListDatasetsResponse,
      DatasetSummary
    ](
      "listDatasets",
      api.listDatasets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.lookoutequipment.model.DatasetSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetsPaginated(request: ListDatasetsRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest,
      ListDatasetsResponse
    ]("listDatasets", api.listDatasets)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListDatasetsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateInferenceScheduler(
        request: UpdateInferenceSchedulerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest,
      UpdateInferenceSchedulerResponse
    ]("updateInferenceScheduler", api.updateInferenceScheduler)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def startDataIngestionJob(request: StartDataIngestionJobRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest,
      StartDataIngestionJobResponse
    ]("startDataIngestionJob", api.startDataIngestionJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.wrap)
      .provideEnvironment(r)
    def listInferenceSchedulers(
        request: ListInferenceSchedulersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest,
      ListInferenceSchedulersResponse,
      InferenceSchedulerSummary
    ](
      "listInferenceSchedulers",
      api.listInferenceSchedulers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.inferenceSchedulerSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.InferenceSchedulerSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInferenceSchedulersPaginated(
        request: ListInferenceSchedulersRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest,
      ListInferenceSchedulersResponse
    ]("listInferenceSchedulers", api.listInferenceSchedulers)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.wrap)
      .provideEnvironment(r)
    def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest,
      DescribeDataIngestionJobResponse
    ]("describeDataIngestionJob", api.describeDataIngestionJob)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.wrap)
      .provideEnvironment(r)
    def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest,
      ListDataIngestionJobsResponse,
      DataIngestionJobSummary
    ](
      "listDataIngestionJobs",
      api.listDataIngestionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataIngestionJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.lookoutequipment.model.DataIngestionJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDataIngestionJobsPaginated(
        request: ListDataIngestionJobsRequest
    ): IO[
      AwsError,
      zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest,
      ListDataIngestionJobsResponse
    ]("listDataIngestionJobs", api.listDataIngestionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.wrap)
      .provideEnvironment(r)
    def describeModel(request: DescribeModelRequest): IO[
      AwsError,
      zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest,
      DescribeModelResponse
    ]("describeModel", api.describeModel)(request.buildAwsValue())
      .map(zio.aws.lookoutequipment.model.DescribeModelResponse.wrap)
      .provideEnvironment(r)
  }
  def listInferenceExecutions(request: ListInferenceExecutionsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceExecutionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceExecutions(request))
  def listInferenceExecutionsPaginated(
      request: ListInferenceExecutionsRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceExecutionsPaginated(request))
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listModels(request: ListModelsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModels(request))
  def listModelsPaginated(
      request: ListModelsRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listModelsPaginated(request))
  def startInferenceScheduler(request: StartInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StartInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startInferenceScheduler(request))
  def createModel(request: CreateModelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def stopInferenceScheduler(request: StopInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StopInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopInferenceScheduler(request))
  def describeDataset(request: DescribeDatasetRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def deleteModel(
      request: DeleteModelRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModel(request))
  def createInferenceScheduler(request: CreateInferenceSchedulerRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.CreateInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInferenceScheduler(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeInferenceScheduler(
      request: DescribeInferenceSchedulerRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeInferenceSchedulerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInferenceScheduler(request))
  def deleteInferenceScheduler(
      request: DeleteInferenceSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteInferenceScheduler(request))
  def listDatasets(request: ListDatasetsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DatasetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(request: ListDatasetsRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateInferenceScheduler(
      request: UpdateInferenceSchedulerRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateInferenceScheduler(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteDataset(
      request: DeleteDatasetRequest
  ): ZIO[zio.aws.lookoutequipment.LookoutEquipment, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataset(request))
  def startDataIngestionJob(request: StartDataIngestionJobRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.StartDataIngestionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDataIngestionJob(request))
  def listInferenceSchedulers(request: ListInferenceSchedulersRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.InferenceSchedulerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceSchedulers(request))
  def listInferenceSchedulersPaginated(
      request: ListInferenceSchedulersRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListInferenceSchedulersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceSchedulersPaginated(request))
  def describeDataIngestionJob(request: DescribeDataIngestionJobRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeDataIngestionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataIngestionJob(request))
  def listDataIngestionJobs(request: ListDataIngestionJobsRequest): ZStream[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DataIngestionJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataIngestionJobs(request))
  def listDataIngestionJobsPaginated(
      request: ListDataIngestionJobsRequest
  ): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.ListDataIngestionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataIngestionJobsPaginated(request))
  def describeModel(request: DescribeModelRequest): ZIO[
    zio.aws.lookoutequipment.LookoutEquipment,
    AwsError,
    zio.aws.lookoutequipment.model.DescribeModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeModel(request))
}
